<?php 
require 'Prozigzig.php';
$h = new Prozigzig();
header('Content-type: application/json');

// Decode JSON input
$data = json_decode(file_get_contents('php://input'), true);

// Validate city_id
if (!isset($data['city_id']) || !is_numeric($data['city_id']) || $data['city_id'] <= 0) {
    echo json_encode([
        "ResponseCode" => "401",
        "Result"       => "false",
        "ResponseMsg"  => "Invalid or missing city_id!"
    ]);
    exit;
}

$city_id = (int)$data['city_id'];
$pointList = [];

$sel = $h->queryfire("SELECT * FROM tbl_points WHERE status=1 AND city_id = $city_id");
while ($row = $sel->fetch_assoc()) {
    $pointList[] = [
        "id"      => $row['id'],
        "title"   => $row['title'],
        "address" => $row['address'],
        "mobile"  => $row['mobile'],
        "lats"    => $row['lats'],
        "longs"   => $row['longs']
    ];
}

// Return response
if (empty($pointList)) {
    $returnArr = [
        "citylist"     => [],
        "ResponseCode" => "200",
        "Result"       => "false",
        "ResponseMsg"  => "No points found for the given city_id!"
    ];
} else {
    $returnArr = [
        "citylist"     => $pointList,
        "ResponseCode" => "200",
        "Result"       => "true",
        "ResponseMsg"  => "Point list found successfully!"
    ];
}

echo json_encode($returnArr);
?>
